//================================================================================================================================================\\
//================================================================================================================================================\\
//================================================================================================================================================\\
//                                                                  FFVI Message                                                                  \\
//                                                                    System                                                                      \\
//                                                                                                                                                \\
//================================================================================================================================================\\
//================================================================================================================================================\\
//================================================================================================================================================\\
// \n - new line
// /t - tab


function messageSystem(message, position, windowShow, speed)
{
  this.open = windowShow || true;
  this.windowShow = windowShow || true;

  this.message = message;
  this.position = position || "bottom";
  if (this.position == "top")
  {
    this.x = 40;
    this.y = 16;
    this.w = 240;
    this.h = 72;
  }
  else
  {
    this.x = 40;
    this.y = 152;
    this.w = 240;
    this.h = 72;
  }
  this.font = messageFont.fontInner;
  this.done = false;
  this.currentPage = 0;
  this.currentLine = 0;
  this.xOffset = 12;
  this.yOffset = 8;
  
  this.speed = speed || 3;
  
  
  this.page = [];
  for (var i = 0; i < this.message.length; i++)
  {
    this.page[i] = [];
  }
  
  this.window = undefined;
  this.updateString();
}

messageSystem.prototype.drawWindow = function(x, y, w, h)
{
  this.baseWindow = CreateSurface(w, h, CreateColor(0, 0, 0, 0));
  
  // Middle Section
  this.back = window7.cloneSection(0, 12, w, 118);
  this.back.blitSurface(window1.cloneSection(0, 13, 1, 118), 0, 0);
  this.back.blitSurface(window1.cloneSection(0, 13, 1, 118), w - 3, 0);
  this.back.blitSurface(window3.cloneSection(0, 13, 1, 118), 1, 0);
  this.back.blitSurface(window3.cloneSection(0, 13, 1, 118), w - 2, 0);
  this.back.blitSurface(window5.cloneSection(0, 13, 1, 118), 2, 0);
  this.back.blitSurface(window5.cloneSection(0, 13, 1, 118), w - 1, 0);
  this.back.blitSurface(window6.cloneSection(0, 13, 1, 118), 3, 0);
  this.back.blitSurface(window6.cloneSection(0, 13, 1, 118), w - 4, 0);
  this.baseWindow.transformBlitSurface(this.back, -1, 6, w - 1, 6, w - 1, 55 + 10, -1, 55 + 10);
  // End Middle Section

  // Top Section
  this.baseWindow.rectangle(0, 0, w, 6, window7.getPixel(0, 0));
  this.baseWindow.blitSurface(topLeftBorder, 0, 0);
  this.baseWindow.blitSurface(topRightBorder, w - 6, 0);
  this.baseWindow.line(6, 0, w - 6, 0, red);
  this.baseWindow.line(6, 1, w - 6, 1, blue);
  this.baseWindow.line(6, 2, w - 6, 2, cyan);
  this.baseWindow.line(6, 3, w - 6, 3, yellow);
  
  this.baseWindow.replaceColor(red, window1.getPixel(0, 0));
  this.baseWindow.replaceColor(green, window2.getPixel(0, 0));
  this.baseWindow.replaceColor(blue, window3.getPixel(0, 0));
  this.baseWindow.replaceColor(magenta, window4.getPixel(0, 0));
  this.baseWindow.replaceColor(cyan, window5.getPixel(0, 0));
  this.baseWindow.replaceColor(yellow, window6.getPixel(0, 0));
  // End Top Section
  
  // Bottom Section
  this.baseWindow.rectangle(0, h - 6, w, 6, window7.getPixel(0, (h - 10) * 2));
  this.baseWindow.blitSurface(bottomLeftBorder, 0, h - 6);
  this.baseWindow.blitSurface(bottomRightBorder, w - 6, h - 6);
  this.baseWindow.line(6, h - 4, w - 6, h - 4, yellow);
  this.baseWindow.line(6, h - 3, w - 6, h - 3, red);
  this.baseWindow.line(6, h - 2, w - 6, h - 2, blue);
  this.baseWindow.line(6, h - 1, w - 6, h - 1, cyan);
  
  this.baseWindow.replaceColor(red, window1.getPixel(0, (h - 10) * 2));
  this.baseWindow.replaceColor(green, window2.getPixel(0, (h - 10) * 2));
  this.baseWindow.replaceColor(blue, window3.getPixel(0, (h - 10) * 2));
  this.baseWindow.replaceColor(magenta, window4.getPixel(0, (h - 10) * 2));
  this.baseWindow.replaceColor(cyan, window5.getPixel(0, (h - 10) * 2));
  this.baseWindow.replaceColor(yellow, window6.getPixel(0, (h - 10) * 2));
  // End Bottom Section
   
  return this.baseWindow.createImage().blit(x, y);
}

messageSystem.prototype.updateString = function()
{
  for (var i = 0; i < this.message.length; i++)
  {
    var currentLetter = 0;
    var currentLine = 0;
    var lastSpace = 0;
    var string = new String(this.message[i]);
    while (currentLetter < string.length)
    {
      currentLetter++;
      if (string.charAt(currentLetter) == '\n') 
      {
        this.page[i][currentLine] = new Object;
        this.page[i][currentLine].line = string.substring(0,currentLetter);
        this.page[i][currentLine].position = 0;
        string = string.slice (currentLetter + 1, string.length);
        currentLine++;
        currentLetter = 0;
      }
      if (string.charAt(currentLetter) == ' ') 
      {
        lastSpace = currentLetter; 
      }
      if (font.fontInner.getStringWidth(string.substring(0,currentLetter)) + this.xOffset + 2 > this.w - this.xOffset)
      {
        if (lastSpace == 0) Abort("Line " + currentLine + " is longer than able to display");
        currentLetter = lastSpace;
        this.page[i][currentLine] = new Object;
        this.page[i][currentLine].line = string.substring(0,currentLetter);
        this.page[i][currentLine].position = 0;
        string = string.slice (currentLetter + 1, string.length);
        currentLine++;
        currentLetter = 0;
      }
      if (currentLetter == string.length)
      {
        this.page[i][currentLine] = new Object;
        this.page[i][currentLine].line = string.substring(0,currentLetter);
        this.page[i][currentLine].position = 0;
      }
    }
  }
}

messageSystem.prototype.update = function()
{
  var numLines = this.page[this.currentPage].length - 1;
  if (this.page[this.currentPage][this.currentLine].position != this.page[this.currentPage][this.currentLine].line.length)
  {
    this.page[this.currentPage][this.currentLine].position += this.speed;
    if (this.page[this.currentPage][this.currentLine].position > this.page[this.currentPage][this.currentLine].line.length)
    {
      this.page[this.currentPage][this.currentLine].position = this.page[this.currentPage][this.currentLine].line.length
    }
  }
  else
  {
    if (this.currentLine != numLines)
    {
      this.currentLine++;
    }
  }
}

messageSystem.prototype.render = function()
{
  RenderMap();
  if (this.windowShow)
  {
    this.drawWindow(this.x, this.y, this.w, this.h);
  }
  for (var i = 0; i < this.page[this.currentPage].length; i++)
  {
    drawText(this.x + 12, this.y + 8 + (i * 15), this.page[this.currentPage][i].line.substring(0, this.page[this.currentPage][i].position), undefined, messageFont);
  }
  FlipScreen();
}

messageSystem.prototype.handleInput = function()
{
  var numLines = this.page[this.currentPage].length - 1;
  while (AreKeysLeft()) 
  {
    switch (GetKey()) 
    {
      case control.buttonA:
      {
        if (this.currentPage != this.page.length -1)
        {
          if (this.page[this.currentPage][numLines].position == this.page[this.currentPage][numLines].line.length)
          {
            this.currentPage++;
            this.currentLine = 0;
          }
        }
        else
        {
          if (this.windowShow)
          {
            this.closing();
          }
          else
          {
            this.done = true;
          }
        }
      }
    }
  }
}

messageSystem.prototype.opening = function()
{
  var factor = 22
  while (this.open)
  {
    UpdateMapEngine();
    RenderMap();
    var factorY = (this.h - factor) / 2
    if (factor < this.h + 1)
    {
      this.drawWindow(this.x, this.y + factorY, this.w, factor);
      FlipScreen();
      factor += 10;
    }
    else
    {
      this.open = false
    }
  }
}

messageSystem.prototype.closing = function()
{
  var factor = 72
  while (!this.done)
  {
    UpdateMapEngine();
    RenderMap();
    
    if (factor > 12)
    {
      var factorY = (this.h - factor) / 2
      this.drawWindow(this.x, this.y + factorY, this.w, factor);
      FlipScreen();
      factor -= 10;
    }
    else
    {
      this.done = true;
    }
  }
}

messageSystem.prototype.execute = function()
{
  while(!this.done)
  {
    if (this.open)
    {
      this.opening();
    }
    else
    {
      UpdateMapEngine();
      this.update();
      this.render();
      this.handleInput();
    }
  }
}

function Message(message, position, windowShow, speed)
{
  var temp = new messageSystem(message, position, windowShow, speed)
  clearKeyQueue();
  temp.execute();
}